const express = require('express');
const router = express.Router();
const { 
  getAllPosts, 
  createPost, 
  updatePost, 
  deletePost, 
  getPostComments, 
  createComment, 
  deleteComment,
  toggleLike
} = require('../controllers/forumController');
const { authenticateToken, optionalAuthenticateToken } = require('../middleware/authMiddleware');

// Public routes (with optional auth for like status)
router.get('/', optionalAuthenticateToken, getAllPosts);
router.get('/:id/comments', getPostComments);

// Protected routes
router.post('/', authenticateToken, createPost);
router.put('/:id', authenticateToken, updatePost);
router.delete('/:id', authenticateToken, deletePost);

router.post('/:id/comments', authenticateToken, createComment);
router.delete('/:id/comments/:commentId', authenticateToken, deleteComment);

router.post('/:id/like', authenticateToken, toggleLike);

module.exports = router;
