const { spawn } = require('child_process');
const path = require('path');

const scripts = [
  'initDb.js',
  'addIsActiveToEvents.js',
  'migrate_registrations.js',
  'migrate_forum.js',
  'add_partner_role.js',
  'seed_event.js',
  'add_slug_to_events.js'
];

const runScript = (scriptName) => {
  return new Promise((resolve, reject) => {
    const scriptPath = path.join(__dirname, scriptName);
    console.log(`[Bootstrap] Running ${scriptName}...`);
    
    const child = spawn('node', [scriptPath], { stdio: 'inherit' });

    child.on('close', (code) => {
      if (code === 0) {
        console.log(`[Bootstrap] ${scriptName} completed successfully.`);
        resolve();
      } else {
        console.error(`[Bootstrap] ${scriptName} failed with code ${code}.`);
        reject(new Error(`${scriptName} failed`));
      }
    });

    child.on('error', (err) => {
        console.error(`[Bootstrap] Error spawning ${scriptName}:`, err);
        reject(err);
    });
  });
};

const bootstrap = async () => {
  console.log('[Bootstrap] Starting automated backend setup...');
  try {
    for (const script of scripts) {
      await runScript(script);
    }
    console.log('[Bootstrap] All initialization scripts executed successfully.');
    process.exit(0);
  } catch (error) {
    console.error('[Bootstrap] Setup failed. Fix the errors before starting the server.');
    console.error(error);
    process.exit(1);
  }
};

bootstrap();
