const { pool } = require('../config/db');

const migrate = async () => {
  const client = await pool.connect();
  try {
    await client.query('BEGIN');
    console.log('Starting migration...');

    // 1. Check if 'details' column exists, if not add it
    console.log('Checking details column...');
    await client.query(`
      DO $$ 
      BEGIN 
        IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name='registrations' AND column_name='details') THEN 
          ALTER TABLE registrations ADD COLUMN details JSONB DEFAULT '{}'::jsonb; 
        END IF; 
      END $$;
    `);

    // 2. Drop the existing primary key (user_id, event_id)
    console.log('Dropping PK...');
    await client.query(`
      ALTER TABLE registrations DROP CONSTRAINT IF EXISTS registrations_pkey;
    `);

    // 3. Make user_id nullable
    console.log('Altering user_id...');
    await client.query(`
      ALTER TABLE registrations ALTER COLUMN user_id DROP NOT NULL;
    `);

    // 4. Add a new ID column as Primary Key
    console.log('Adding ID column...');
    await client.query(`
      DO $$ 
      BEGIN 
        IF NOT EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name='registrations' AND column_name='id') THEN 
          ALTER TABLE registrations ADD COLUMN id SERIAL PRIMARY KEY; 
        END IF; 
      END $$;
    `);

    await client.query('COMMIT');
    console.log('Migration successful');
  } catch (e) {
    await client.query('ROLLBACK');
    console.error('Migration failed', e);
  } finally {
    client.release();
    process.exit(0);
  }
};

migrate();
